<!--3h_GE_KARAMOUZIS-->
<!DOCTYPE html>
<?php
session_start();
include ('config.php');
?>

<html lang="el">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="eapstyle.css">
  <title>Διαχείριση εργασιών</title>

</head>

<body>

  <header>

    <div class="headerblock" style="max-width:300px; height:120px; ">

    <a href="index.php"><img src="./assets/pictures/EAP-LOGO-COLOR2-800x322.png.webp" width="400" height="161" alt="EAP Logo"></a> 

    </div>

    <div class="headerblock" style="align: center; text-align: center; ">
      <h1>Διαχείριση Εργασιών</h1>
      <?php
      echo "<div class=\"header-buttons\">";
      echo "<button class=\"tablinks active\" onclick=\"changeTab(event, 'home')\">Αρχική </button>";
      if (isset($_SESSION['userID'])) {
        if ($_SESSION['role'] == "admin") {
          echo "<button class=\"tablinks\" onclick=\"changeTab(event, 'tasklist')\">Εργασίες</button>";
          echo "<button class=\"tablinks\" onclick=\"changeTab(event, 'groups')\">Ομάδες</button>";
          echo "<a href=\"logout.php\"><button>Αποσύνδεση</button></a>";
        } else if ($_SESSION['role'] == "user") {
          echo "<button class=\"tablinks\" onclick=\"changeTab(event, 'tasklist')\">Εργασίες</button>";
          echo "<a href=\"logout.php\"><button>Αποσύνδεση</button></a>";
        } else  //Να κάνω Guest ή πελάτη αν ζητηθεί
          echo "<button class=\"tablinks\" onclick=\"changeTab(event, 'tasklist')\">Εργασίες</button>";
      } else {
        echo "<button class=\"tablinks active\" onclick=\"changeTab(event, 'login')\">Σύνδεση</button>";
        echo "<button class=\"tablinks active\" onclick=\"changeTab(event, 'registration')\">Εγγραφή</button></a>";
      }
      echo "</div>";
      ?>
    </div>

    <div class="headerblock3" style="width:300px; height:120px; ">

      <?php
      if (isset($_SESSION['userID'])) {
        if ($_SESSION['role'] == "admin") {
          echo "<span style=\"padding-right: 40px; font-style:bold; color:blue;\">Έχετε συνδεθεί ως διαχειριστής</span>";

        } else {
          echo "<span style=\"padding-right: 40px; font-style:bold; color:blue;\">Έχετε συνδεθεί ως απλός χρήστης</span>";

        }
        echo "<br><span style=\"padding-right: 40px; font-size: 20px; font-style:bold; color:blue;\">" . $_SESSION['name'] . "</span>";
      } else {
        echo "<span style=\"padding-right: 40px; font-style:bold; color:red;\">Δεν έχετε συνδεθεί</span>";
      }
      ?>

    </div>


  </header>

  <div id="home" class="content active">

    <h2 class="landingpage"> Καλώς ήρθατε στην ομάδα μας!</h2>
    <p class="landingpage">

      Είμαστε ενθουσιασμένοι που σας καλωσορίζουμε στην πλατφόρμα μας, τον ψηφιακό χώρο όπου η δημιουργικότητα συναντά
      την παραγωγικότητα. Εδώ, κάθε εργαζόμενος αποτελεί μέρος μιας δυναμικής κοινότητας που επιδιώκει να φέρει σε πέρας
      ενδιαφέροντα και προκλητικά έργα, αναπτύσσοντας παράλληλα τις προσωπικές του δεξιότητες.

      Στην πλατφόρμα μας, θα βρείτε όλα τα εργαλεία που χρειάζεστε για να οργανώσετε τις εργασίες σας, να συνεργαστείτε
      με συναδέλφους και να παρακολουθήσετε την πρόοδο των έργων σας σε πραγματικό χρόνο. Είμαστε εδώ για να σας
      υποστηρίξουμε σε κάθε βήμα, εξασφαλίζοντας ότι θα έχετε μια ομαλή και εποικοδομητική εμπειρία.

      Αναζητήστε στην πλατφόρμα μας τους πόρους καθοδήγησης και τα εκπαιδευτικά εργαλεία που έχουμε δημιουργήσει για
      εσάς. Μην διστάσετε να επικοινωνήσετε με την ομάδα υποστήριξης για οποιαδήποτε ερωτήσεις ή ανάγκες που μπορεί να
      έχετε.
    </p>
  </div>


  <div id="login" class="content">


    <h2 class="landingpage"> Σύνδεση Χρήστη </h2>


    <div class="landingpage">
      <form action="login.php" method="post">
        <div class="container">
          <label for="username"><b>Χρήστης</b></label><br>
          <input type="text" placeholder="Εισάγετε το όνομα χρήστη" name="username" required><br>

          <label for="password"><b>Κωδικός</b></label><br>
          <input type="password" placeholder="Εισάγετε τον κωδικό σας" name="password" required><br>

          <button class="loginbutton" type="submit">Σύνδεση</button>

        </div>

        <div class="container">
          <input type="checkbox" checked="checked" name="remember"> Να με θυμάσαι!
          <span style="float: right;" class="password">Ξέχασα τον <a href="#">κωδικό</a> μου!</span>
        </div>
      </form>

    </div>

  </div>

  <div id="registration" class="content">

    <h2 class="landingpage"> Εγγραφή Χρήστη </h2>


    <div class="landingpage">

      <form action="register.php" method="post" name="registrationform" onsubmit="return formvalidation()">
        <div class="container">

          <label for="name"><b>Επωνυμία</b></label><br>
          <input type="text" placeholder="Όνομα Επώνυμο" name="name" required><br>

          <label for="email"><b>email</b></label><br>
          <input type="text" placeholder="Email" name="email" required><br>

          <label for="username"><b>Χρήστης</b></label><br>
          <input type="text" placeholder="Εισάγετε το όνομα χρήστη" name="username" required><br>

          <label for="password"><b>Κωδικός</b></label><br>
          <input type="password" placeholder="Εισάγετε τον κωδικό σας" name="password" required><br>

          <label for="password"><b>Επιβεβαίωση Κωδικού</b></label><br>
          <input type="password" placeholder="Εισάγετε τον κωδικό σας" name="passwordconfirmation" required><br>

          <input type="hidden" name="role" value="user"><br>

          <button class="registerbutton" type="submit">Εγγραφή</button>

        </div>

        <div class="container">
          <span style="float: right; padding-bottom: 20px; color: red;" class="password">Όλα τα πεδία είναι απαραίτητα.</span>
        </div>
      </form>

    </div>

  </div>


  <footer>
    <div class="footer-buttons">
    <a href="./assets/files/terms-oreina.epidomata.gov.gr.pdf" target="_blank"><button>Όροι Χρήσης</button></a>
    <a href="./assets/files/ementor-politiki-prostasias-pd.pdf" target="_blank"><button>Πολιτική Απορήτου</button></a>
    <a href="./assets/files/adhgies.pdf" target="_blank"><button>Οδηγίες Ολοκλήρωσης εργασιών</button></a>
    </div>
  </footer>


<!-- TAB & inner content -->
  <script>
    function changeTab(evt, innercontent) {
      var i, content, tablinks;
      content = document.getElementsByClassName("content");
      for (i = 0; i < content.length; i++) {
        content[i].style.display = "none";
      }

      tablinks = document.getElementsByClassName("tablinks");
      for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
      }
      document.getElementById(innercontent).style.display = "block";
      evt.currentTarget.className += " active";
    }
    document.addEventListener("DOMContentLoaded", function () { changeTab(event, 'home'); });
  </script>


    <!-- registration validation form -->

    <script>
      function formvalidation(){
        let name = document.forms["registrationform"]["name"].value ;
        let email = document.forms["registrationform"]["email"].value ;
        let username = document.forms["registrationform"]["username"].value ;
        let password = document.forms["registrationform"]["password"].value ;
        let passwordconfirmation = document.forms["registrationform"]["passwordconfirmation"].value ;

        /*
        if(name === null || email === null || username === null || password === null || passwordconfirmation === null ){
          alert("Θα πρέπει να συμπληρώσετε όλα τα πεδία!");
          return false;
        }

        let p = emai.includes("@");
        */
        
        if (!email.includes("@")){
            alert("Θα πρέπει να υπάρχει το σύμβολο \"@\" στο email");
            return false;

        }


      }

    </script>



</body>

</html>